#ifndef _COREGC_H_
#define _COREGC_H_

//~~~~~~~~~~~~~~~~~~~~
#include <Canvas.h> 
//~~~~~~~~~~~~~~~~~~~~


typedef INT32  FIX;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                                TCoreGC
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TCoreGC : public TCanvas
{
public: // Types

  //*** PPOP Operation Codes
  enum { PP_REPLACE = 0, PP_XOR, PP_NSAND, PP_ADDS, PP_MIN, PP_OR };

public: // Methods

  //*** Is it ok to proceed?
  bool Proceed() const;

  //---------------------------------------------------------------------
  //                Platform Independent Register Access
  //---------------------------------------------------------------------


  //*** Current Background\Foreground Colors
  void   Set_color0( TColor clr );
  void   Set_color1( TColor clr );
  TColor Get_color0();
  TColor Get_color1();

  TColor GetBackgroundColor();
  TColor GetForegroundColor();

  UINT32 ReplicatePixel  ( INT32  clr   );
  INT32  UnReplicatePixel( UINT32 value );

  bool   IsRandomized();

  //*** Set/Get the current pixel size
  void   Set_psize( UINT32 pixel_size );
  UINT32 Get_psize();

  //*** Set/Get the current pixel operation
  void   Set_ppop( UINT32 operation );
  UINT32 Get_ppop();
  
  //*** Transparency
  void TranspON ();
  void TranspOFF();
  bool GetTransp();

  //*** Window Clipping methods and modes
  enum { WM_NONE = 0, WM_CLIP };
  void   Set_wmode( UINT32 wm );
  UINT32 Get_wmode();
  
  //*** Drawing Optimization Mode (fast,basic vs slow,advanced)
  void FastMode   ( bool on = true );
  bool GetFastMode();

  //*** Set/Get the plane mask 
  void   Set_pmask( UINT32 pm );
  UINT32 Get_pmask();

  //*** Set/Get the clipping window start and end points
  void   Set_wstart( UINT32 ws );
  void   Set_wend  ( UINT32 we );
  UINT32 Get_wstart();
  UINT32 Get_wend  ();

  //---------------------------------------------------------------------
  //                        Fixed Point Methods
  //---------------------------------------------------------------------

  //*** Fixed point Sin\Cos
  FIX  FixCos( FIX angle );
  FIX  FixSin( FIX angle );

  //*** Sin\Cos fixed point table and table lookup method
  static const FIX sincos_table[];
  FIX Lookup( FIX angle, bool positive, bool negate );

  //*** Conversion Methods
  void Int16ToFix   ( INT32 n_elements, INT16 in_array[], FIX   out_array[] );
  void FixToInt16   ( INT32 n_elements, FIX   in_array[], INT16 out_array[] );
  void Int32ToFix   ( INT32 n_elements, INT32 in_array[], FIX   out_array[] );
  void FixToInt32   ( INT32 n_elements, FIX   in_array[], INT32 out_array[] );
  void VertexToPoint( INT32 nverts, INT32 in_array[], POINT out_array[] );
  FIX  FloatToFix   ( float flt );

  // Determine the index of the font with the specified name.
  INT32 FontNameToIndex( const char* fontname );

};


#endif  // _COREGC_H_
